/*******************************************************************************
	Ejemplo de Google Gears
	======================================================================
	Este archivo de ejemplo ha sido desarrollado para el artculo:
	"Conociendo las posibilidades de Google Gears" escrito por Reynier 
	Matos Padilla para www.maestrosdelweb.com
	======================================================================
	
	Blog del autor:
	http://zenkius.blogspot.com
	
	Vea otros artculos en:
	http://www.maestrosdelweb.com/autores/reynier-matos-padilla/
*******************************************************************************/

// Cambie el varlor de esta variable si desea establecer el nombre del 
// almacn de datos que va a crear.
// Este nombre es utilizado con los mtodos createManagedStore(), removeManagedStore()
// y openManagedStore() de la API de Google Gears. Esto es invisible para el usuario.
var STORE_NAME = "mi_aplicacion_offline";

// Cambie esa variable para establecer la URL del archivo manifest, el cual describa
// cules URLs sern capturadas, que pueden ser relativas a la pgina actual o URL absolutas.
var MANIFEST_FILENAME = "manifest.json";

var localServer;
var store;

// Llamada para inicializar el servidor local y la variable store.
function init() {
  if (!window.google || !google.gears) {
    textOut("NOTA:  Antes debe instalar Google Gears.");
  } else {
    localServer = google.gears.factory.create("beta.localserver");
    store = localServer.createManagedStore(STORE_NAME);
    textOut("Google Gears est instalado.");
  }
}

// Crea el almacn en el servidor local con los archivos del sitio
function createStore() {
  if (!window.google || !google.gears) {
    alert("Antes debe instalar Google Gears.");
    return;
  }

  store.manifestUrl = MANIFEST_FILENAME;
  store.checkForUpdate();

  var timerId = window.setInterval(function() {
    // Cuando la propiedad currentVersion tiene un valor, todo el contenido 
    // relacionado en el archivo manifest de esta versin ser capturado.
    if (store.currentVersion) {
      window.clearInterval(timerId);
      textOut("Los documentos est&aacute;n disponibles sin conexi&oacute;n.\n" + 
              "Cuando su navegador no tenga conexi&oacute;n, la carga de documentos " +
              "ser&aacute; mediante la misma URL para ver el contenido almacenado " +
			        "localmente. La versi&oacute;n guardada es: " + 
              store.currentVersion);
    } else if (store.updateStatus == 3) {
      textOut("Error: " + store.lastErrorMessage);
    }
  }, 500);  
}

// Elimina los datos almacenados en el servidor local para esta aplicacin.
function removeStore() {
  if (!window.google || !google.gears) {
    alert("Antes debe instalar Google Gears.");
    return;
  }

  localServer.removeManagedStore(STORE_NAME);
  textOut("Hecho. La copia local ha sido eliminada." +
          "Ahora ver&aacute; la versin en l&iacute;nea de los documentos.");
}

// Funcin para devolver el texto de estado.
function textOut(s) {
 var elm = document.getElementById("textOut");
  while (elm.firstChild) {
    elm.removeChild(elm.firstChild);
  } 
  elm.appendChild(document.createTextNode(s));
}
